-- Database Queen Florist Events Management
CREATE DATABASE IF NOT EXISTS queen_florist;
USE queen_florist;

-- Tabel Events
CREATE TABLE IF NOT EXISTS events (
    id INT AUTO_INCREMENT PRIMARY KEY,
    month TINYINT NOT NULL COMMENT 'Bulan (1-12)',
    day TINYINT NOT NULL COMMENT 'Hari (1-31)',
    title VARCHAR(255) NOT NULL COMMENT 'Judul event',
    description TEXT COMMENT 'Deskripsi event',
    is_active TINYINT(1) DEFAULT 1 COMMENT 'Status aktif (1=aktif, 0=non-aktif)',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    INDEX idx_month_day (month, day),
    INDEX idx_is_active (is_active)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabel Admin Sessions
CREATE TABLE IF NOT EXISTS admin_sessions (
    id INT AUTO_INCREMENT PRIMARY KEY,
    session_id VARCHAR(255) NOT NULL UNIQUE,
    admin_id VARCHAR(50) NOT NULL,
    ip_address VARCHAR(45),
    user_agent TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    expires_at TIMESTAMP NOT NULL,
    is_active TINYINT(1) DEFAULT 1,
    INDEX idx_session_id (session_id),
    INDEX idx_expires_at (expires_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Insert sample data
INSERT INTO events (month, day, title, description, is_active) VALUES
(1, 15, 'Valentine Preparation', 'Persiapan untuk Hari Valentine dengan berbagai rangkaian bunga spesial', 1),
(2, 14, 'Valentine Day Special', 'Promosi spesial Hari Valentine dengan diskon 20% untuk semua rangkaian bunga', 1),
(3, 8, 'Women\'s Day Celebration', 'Perayaan Hari Wanita dengan rangkaian bunga yang elegan', 1),
(4, 21, 'Kartini Day', 'Memperingati Hari Kartini dengan rangkaian bunga tradisional', 1),
(5, 1, 'Mother\'s Day Special', 'Hari Ibu spesial dengan berbagai pilihan bunga untuk ibu tercinta', 1),
(6, 17, 'Mid Year Sale', 'Promosi pertengahan tahun dengan diskon hingga 30%', 1),
(8, 17, 'Independence Day', 'Perayaan Hari Kemerdekaan dengan rangkaian bunga merah putih', 1),
(10, 25, 'Halloween Special', 'Rangkaian bunga tema Halloween yang unik dan menarik', 1),
(12, 25, 'Christmas Celebration', 'Perayaan Natal dengan dekorasi bunga khas Natal', 1),
(12, 31, 'New Year Eve', 'Persiapan Tahun Baru dengan rangkaian bunga premium', 1);

-- Create admin user (password: admin123, hashed with password_hash)
INSERT INTO admin_sessions (session_id, admin_id, ip_address, expires_at) VALUES 
('init_session', 'admin', '127.0.0.1', DATE_ADD(NOW(), INTERVAL 1 YEAR));